<?php
require_once dirname(__DIR__, 2) . '/config/config.php';

// Check if the user is logged in
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    // Redirect or return error if not logged in
    // For now, let's assume this is called via AJAX or a specific page
    // that already checks login. We'll return JSON for potential AJAX use.
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'User not logged in.']);
    exit;
}

$response = ['success' => false, 'message' => 'An error occurred.'];

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['group_id'])) {
    $group_id = (int)$_POST['group_id'];
    $user_id = $_SESSION['id'];

    // Optional: Verify if the user has permission to create invites for this group (e.g., is owner or admin)
    // For simplicity, we'll allow any member to create an invite for now.
    // A more robust check would query the groups or group_members table for roles/ownership.
    $sql_check_member = "SELECT 1 FROM group_members WHERE user_id = :user_id AND group_id = :group_id";
    $stmt_check = $pdo->prepare($sql_check_access);
    $stmt_check->bindParam(":user_id", $user_id, PDO::PARAM_INT);
    $stmt_check->bindParam(":group_id", $group_id, PDO::PARAM_INT);
    $stmt_check->execute();

    if ($stmt_check->rowCount() > 0) {
        // Generate a unique invite code
        // Simple approach: generate random string and check for collisions (unlikely with sufficient length)
        $max_attempts = 5;
        $attempt = 0;
        $invite_code = '';
        $code_generated = false;

        while ($attempt < $max_attempts && !$code_generated) {
            $invite_code = substr(str_shuffle(str_repeat('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', 10)), 0, 10);
            
            // Check if code already exists
            $sql_check_code = "SELECT id FROM invitations WHERE code = :code";
            $stmt_check_code = $pdo->prepare($sql_check_code);
            $stmt_check_code->bindParam(":code", $invite_code, PDO::PARAM_STR);
            $stmt_check_code->execute();

            if ($stmt_check_code->rowCount() == 0) {
                $code_generated = true;
            }
            unset($stmt_check_code);
            $attempt++;
        }

        if ($code_generated) {
            // Insert the new invite code into the database
            // For simplicity, let's make invites expire in 7 days and have unlimited uses for now
            $expires_at = date('Y-m-d H:i:s', strtotime('+7 days'));
            $max_uses = 0; // 0 for unlimited

            $sql_insert_invite = "INSERT INTO invitations (group_id, inviter_id, code, expires_at, max_uses) VALUES (:group_id, :inviter_id, :code, :expires_at, :max_uses)";
            if ($stmt_insert = $pdo->prepare($sql_insert_invite)) {
                $stmt_insert->bindParam(":group_id", $group_id, PDO::PARAM_INT);
                $stmt_insert->bindParam(":inviter_id", $user_id, PDO::PARAM_INT);
                $stmt_insert->bindParam(":code", $invite_code, PDO::PARAM_STR);
                $stmt_insert->bindParam(":expires_at", $expires_at, PDO::PARAM_STR);
                $stmt_insert->bindParam(":max_uses", $max_uses, PDO::PARAM_INT);

                if ($stmt_insert->execute()) {
                    $response = ['success' => true, 'invite_code' => $invite_code, 'expires_at' => $expires_at];
                } else {
                    $response['message'] = 'Failed to save invite code.';
                }
                unset($stmt_insert);
            }
        } else {
            $response['message'] = 'Failed to generate a unique invite code after multiple attempts.';
        }
    } else {
        $response['message'] = 'You are not a member of this group.';
    }
    unset($stmt_check);

} else {
    $response['message'] = 'Invalid request method or missing group ID.';
}

// Close connection
unset($pdo);

// Return JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>
